/*= EIP123x Include File ==================================================*/

/*=========================================================================*/
/*  Please note that the use of global variables or arrays in the Include  */
/*  file is no longer allowed.                                             */
/*=========================================================================*/

/*= GLOBAL CONSTANT DECLARATIONS ==========================================*/
/* Replace 10 with the maximum number of devices of this type being used.  */
#define eip123x_MAX_INSTR   10
#define NI_VXI  1
#define NI_GPIB 2

/*= GLOBAL FUNCTION DECLARATIONS ==========================================*/
extern int
   eip123x_init (int logicalAddress, int interface, int IDQuery, int resetDevice, int *instrumentID, int *modelNumber),
   eip123x_band_eip1230 (int instrumentID, int primaryBand, int subBandGHz),
   eip123x_band_eip1231 (int instrumentID, int bandEIP1231A),
   eip123x_center_freq (int instrumentID, double centerFreqMHz),
   eip123x_freq_win_lim (int instrumentID, double lowLimitMHz, double highLimitMHz),
   eip123x_sample_rate (int instrumentID, long sampleRatemSec),
   eip123x_resolution (int instrumentID, int resolution),
   eip123x_freq_avr (int instrumentID, int frequencyAverage),
   eip123x_freq_offset (int instrumentID, int freqMultiplier, double freqOffsetGHz),
   eip123x_min_freq_rep (int instrumentID, double minPulseRepFreq, int minPRFUnits),
   eip123x_inhibit_input (int instrumentID, int inhibitInputSource),
   eip123x_time_base (int instrumentID, int timeBaseSource),
   eip123x_trig_setup (int instrumentID, int syncTrigLine, int asyncTrigLine),
   eip123x_special_funct (int instrumentID, int selectSpecial, double *returnedReading),
   eip123x_terminate_spec (int instrumentID),
   eip123x_hold_func (int instrumentID, int hold),
   eip123x_set_meas_type (int instrumentID, int measurementType),
   eip123x_trigger_func (int instrumentID, int function),
   eip123x_get_measurement (int instrumentID, double *measurement),
   eip123x_counter_setup (int instrumentID, int mode, int setupRegister),
   eip123x_save_default_setup (int instrumentID),
   eip123x_get_gen_setup_info (int instrumentID, int setup, char display[]),
   eip123x_write (int instrumentID, char writeBuffer[]),
   eip123x_read (int instrumentID, int numberBytesToRead, char readBuffer[], long *numBytesRead),
   eip123x_reset (int instrumentID),
   eip123x_error_query (int instrumentID, int action, int *_123xErrorNumber, char errorMessage[]),
   eip123x_revision_query (int instrumentID, char driverRevision[], char firmwareRevision[]),
   eip123x_close (int instrumentID);

/*=== END OF INCLUDE FILE ====+=============================================*/
